/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.conductor.toolbox;

import com.railwayteam.railways.Railways;
import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.content.conductor.toolbox.MountedToolbox;
import com.railwayteam.railways.registry.CRContainerTypes;
import com.simibubi.create.content.curiosities.toolbox.ToolboxContainer;
import com.simibubi.create.content.curiosities.toolbox.ToolboxTileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;

public class MountedToolboxContainer
extends ToolboxContainer {
    private ConductorEntity conductor;

    public MountedToolboxContainer(MenuType<?> type, int id, Inventory inv, FriendlyByteBuf extraData) {
        super(type, id, inv, extraData);
    }

    public MountedToolboxContainer(MenuType<?> type, int id, Inventory inv, MountedToolbox toolbox) {
        super(type, id, inv, (ToolboxTileEntity)toolbox);
        toolbox.startOpen(this.player);
    }

    public static MountedToolboxContainer create(int id, Inventory inv, MountedToolbox toolbox) {
        return new MountedToolboxContainer((MenuType)CRContainerTypes.MOUNTED_TOOLBOX.get(), id, inv, toolbox);
    }

    protected void init(Inventory inv, ToolboxTileEntity contentHolderIn) {
        super.init(inv, (Object)contentHolderIn);
        this.conductor = ((MountedToolbox)contentHolderIn).parent;
    }

    protected ToolboxTileEntity createOnClient(FriendlyByteBuf extraData) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        int conductorId = extraData.m_130242_();
        Entity entity = world.m_6815_(conductorId);
        if (!(entity instanceof ConductorEntity)) {
            Railways.LOGGER.error("Conductor with ID not found: " + conductorId);
            return null;
        }
        ConductorEntity conductor = (ConductorEntity)entity;
        MountedToolbox toolbox = conductor.getOrCreateToolboxHolder();
        toolbox.read(extraData.m_130260_(), true);
        return toolbox;
    }

    public boolean m_6875_(Player player) {
        return player.m_20280_((Entity)this.conductor) < 64.0;
    }
}

